#ifndef _SCAN_H_
#define _SCAN_H_

#include <stdio.h>
#include <errno.h>


#define VERBOSE 1
#ifdef VERBOSE
#define MSG(x...) 							\
do {									\
	fprintf (stderr, x);						\
	fprintf (stderr, "\n");						\
} while (0)
#else
#define MSG(x...)
#endif

#define WARN(x...) 							\
do {									\
	fprintf (stderr, "WARNING (%s:%i): ", __FUNCTION__, __LINE__);	\
	fprintf (stderr, x);						\
	fprintf (stderr, "\n");						\
} while (0)


#define PERROR(x...) 							\
do {									\
	fprintf (stderr, "ERROR: ");					\
	fprintf (stderr, x);						\
	fprintf (stderr, " (");						\
	fprintf (stderr, strerror(errno));				\
	fprintf (stderr, ")\n");					\
	exit (-1);							\
} while (0)


#endif

