/* 
    tuxview for v4l frame grabber driver and linux_dvb

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/videodev.h>
#include <fcntl.h>
#include <locale.h>

#include "interface2.hh"
#include "common.hh"

int anz_dev = 0;
gint XDIM = 640;
gint YDIM = 480;


char devices[MAX_DEV][STRSIZE];
int xv = 0;

int main(int argc, char *argv[])
{
	int c, bpp = 0, remote = 0, norm = 0, onoff = 1, channel = 0;
	int device = -1;
	int ipaq = 0;
	
	gtk_set_locale();
#ifdef ENABLE_NLS	
	bindtextdomain(PACKAGE, LOCALE_DIR);
	textdomain(PACKAGE);
#endif



	for (;;) {
		if (-1 == (c = getopt(argc, argv, "ir:od:b:n:c:x")))
			break;
		switch (c) {
		case 'i':
			ipaq = 1;
			break;
		case 'x':
			xv = 1;
			break;
		case 'r':
			remote = atoi(optarg);
			break;
		case 'o':
			onoff = 0;
			break;
		case 'd':
			device = atoi(optarg);
			break;
		case 'b':
			bpp = atoi(optarg);
			break;
		case 'n':
			norm = atoi(optarg);
			break;

		case 'h':
		default:
			cerr << _("usage: ") << argv[0] << _("  [ options ] ") 
			     <<	endl << endl << _("options:") << endl 
			     << _("    -r <n>    remote = 1, overlay = -1 ") 
			     << endl 
			     << _("    -i        use ipaq dimensions") << endl 
			     << _("    -o        start with capture off") << endl
			     << _("    -d <n>    video device nb   ") 
			     << 		  _("[0=/dev/video0]") << endl 
			     << _("    -b <n>    displays color depth is <n> bpp")
			     << endl 
			     << _("    -n <n>    set television norm (PAL=0,NTSC=1,SECAM=2)") 
			     << endl;
			exit(1);
		}
	}

	if (ipaq) {
		XDIM = 310;
		YDIM = 230;
	}
	if (device <0)
		for (int i=0; i< MAX_DEV; i++){
			stringstream str;
			str << "/dev/video" << i << ends;
			int fd = open(str.str().c_str(),O_RDONLY);
			if(fd >= 0) {
				struct video_capability vcap;
				
				if (ioctl(fd,VIDIOCGCAP,&vcap)<0){
				  cerr << _("ERROR: getting video ")
					     <<_("capabilities") << endl;
				} else {
					if ((vcap.type & VID_TYPE_CAPTURE) ||
					    (vcap.type & VID_TYPE_OVERLAY)){
						
						anz_dev++;
						cerr << _("found v4l device ")
						     << str.str() << endl;
						strcpy(devices[anz_dev-1],
						       str.str().c_str());
					}
				}
				close(fd);
			}
		}
	else anz_dev = 1;
	if (!anz_dev){
		cerr << "No video4linux device found" << endl;
		exit (1);
	}

	gtk_init(&argc, &argv);
	init_graphics(device, bpp, norm, remote, onoff, channel);

	return 0;
}
