/* 
    tuxplayer.cc

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <linux/videodev.h>
#include <fcntl.h>
#include <locale.h>
#include <cdk/cdk.h>


#include "tuxplayer_xpm.h"
#include "common.hh"
#include "dvb_formats.h"

extern GtkWidget *statusbar;
GtkWidget *stwidget;
extern gint contextid;
static GtkAccelGroup *accel_group;
static int XDIM;
static int YDIM;
static int pfileset;
static int sfileset;
static char playfile[256];
static char savefile[256];
int fdv = -1;
int fda = -1;
int fddvr = -1;
int fdin = -1;
int fdout = -1;
int device = 0;
ipack pa;
ipack pv;
int ptimer;
#ifdef PTHREADS
int save_format = C_MPEG;
int ftype = C_MPEG;
pthread_t threadp;
pthread_t threadr;
dvr_info_t pdinfo;
dvr_info_t rdinfo;
#endif

#define IPACKS 2048
#define MAXAPIDS 32

enum { DUMMY, RECORD, PLAY, STOP, PAUSE, FFWD, SLOW, FSKP, BSKP };


void quit(GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_exit(0);
	if (fda > 0) audioSetAVSync(fda, true);
	
	close(fdv);
	close(fda);
}

void pes_write (uint8_t *buf, int count, void *data)
{
	write(fdout, buf, count);
}

static gint check_thread(gpointer data)
{
	if (pdinfo.stop){
		gtk_idle_remove(ptimer);
		ptimer = 0;
		gtk_toggle_button_set_active((GtkToggleButton *) stwidget, 
					     true);
	}
        return TRUE;
}


static void fpr(int what)
{
	char buf[80];
	ostringstream str(string(buf, 80));

	switch (what) {
	case PLAY:
		str << "Playing file: " << playfile << ends;
		status_message(buf);
		ftype = check_file_ts(playfile);
		if ((fdin = open(playfile, O_RDONLY)) < 0) {
			perror("playfile");
			cerr << "Couldn't open " << playfile << endl;
		} else {
			switch(ftype){
			case C_NOPES:
				status_message("Assuming program stream");
				ftype = C_MPEG;
				break;
		
			case C_MPEG:
				status_message("Program or System stream");
				break;
		
			case C_TS:
				status_message("Transport stream");
				break;
			}
			
			pdinfo.stop = 0;
			pdinfo.dev = device;
			pdinfo.length = 0;
			pdinfo.type = ftype;
			pdinfo.filefd = fdin;
			ptimer = gtk_idle_add(check_thread, NULL);

			c_dvr_thread_play(&threadp, &pdinfo);
		} 
		break;

	case RECORD:
		str << "Recording file: " << savefile << ends;
		status_message(buf);
		if ((fdout = open(savefile, O_CREAT | O_RDWR | O_TRUNC,				       S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|
				       S_IROTH|S_IWOTH)) < 0) {
			perror("savefile");
			cerr << "Couldn't open " << savefile << fdout<< endl;
		} else {
			char devname[80];
			char devname2[80];
			int fddmx;
			uint16_t pids[5];
			
			sprintf(devname2,"/dev/ost/dvr%d",device);
			if ((fddvr = open(devname2,O_RDONLY)) < 0)
				perror(devname2);
			sprintf(devname,"/dev/ost/demux%d",device);
			fddmx = open(devname, O_RDWR);
			if (ioctl(fddmx, DMX_GET_PES_PIDS, pids) < 0)
				perror("open demux");
			if (pids[0] != 65535 && pids[1] != 65535){
				rdinfo.stop = 0;
				rdinfo.dev = device;
				rdinfo.length = 0;
				rdinfo.type = save_format;
				rdinfo.pida = pids[0];
				rdinfo.pidv = pids[1];
				rdinfo.fd_dvr = fddvr;
				rdinfo.filefd = fdout;
				c_dvr_thread_record(&threadr, &rdinfo);

			} else {
				cerr << "Couldn't get audio or video pid " 
				     << savefile << endl;
			}
			
		}		
		break;
	}

}

static void frecord(GtkWidget * w, GtkFileSelection * fs)
{
	gchar *name;

	name = gtk_file_selection_get_filename(fs);
	int len = strlen(name);
	strncpy(savefile, name, len);
	savefile[len] = '\0';
	gtk_widget_destroy(GTK_WIDGET(fs));
	sfileset = TRUE;
	fpr(RECORD);
}

static void fplay(GtkWidget * w, GtkFileSelection * fs)
{
	gchar *name;

	name = gtk_file_selection_get_filename(fs);
	int len = strlen(name);
	strncpy(playfile, name, len);
	playfile[len] = '\0';
	gtk_widget_destroy(GTK_WIDGET(fs));
	pfileset = TRUE;
	fpr(PLAY);

}

void play_record(int l)
{
	GtkWidget *filew;
	filew = gtk_file_selection_new("File selection");

	switch (l) {
	case PLAY:
		if (!pfileset) {
			gtk_signal_connect(GTK_OBJECT
					   (GTK_FILE_SELECTION(filew)->
					    ok_button), "clicked",
					   (GtkSignalFunc) fplay, filew);
			gtk_signal_connect_object(GTK_OBJECT
						  (GTK_FILE_SELECTION
						   (filew)->cancel_button),
						  "clicked",
						  (GtkSignalFunc)
						  gtk_widget_destroy,
						  GTK_OBJECT(filew));

			gtk_widget_show(filew);
		} else
			fpr(l);
		break;
	case RECORD:
		if (!sfileset) {
			gtk_signal_connect(GTK_OBJECT
					   (GTK_FILE_SELECTION(filew)->
					    ok_button), "clicked",
					   (GtkSignalFunc) frecord, filew);
			gtk_signal_connect_object(GTK_OBJECT
						  (GTK_FILE_SELECTION
						   (filew)->cancel_button),
						  "clicked",
						  (GtkSignalFunc)
						  gtk_widget_destroy,
						  GTK_OBJECT(filew));

			gtk_widget_show(filew);
		} else
			fpr(l);
		break;
	}
}


void switches(GtkWidget * widget, gpointer data)
{
	//int in;
	//int cap;
	int act=0;
	//switch_t sw;
	//av_settings av;
	int cc=0;


	int l = (int) data;
	if (GTK_WIDGET_VISIBLE(widget)) {
		switch (l) {

		case RECORD:
			act = int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			if (act && rdinfo.stop)
				play_record(RECORD);
			break;

		case PLAY:
			act = int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			if (act && rdinfo.stop){
				status_message("playing");
				if (!threadp){
					play_record(PLAY);
				} else {
					cc = 'c';
				}
			}
			break;

		case PAUSE:
			act = int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			if (act && rdinfo.stop){
					cc = 'z';			
			}
			break;

		case STOP:
			act = int (gtk_toggle_button_get_active
				 ((GtkToggleButton *) widget));
			if (rdinfo.stop){
				status_message("Replay stopped");
				pdinfo.stop = 1;
				threadp = 0;
			} else {
				status_message("Recording stopped");
				rdinfo.stop = 1;
				threadr = 0;
			}
			break;

		case FFWD:
			act = int (gtk_toggle_button_get_active
				   ((GtkToggleButton *) widget));
			if (act && threadp){
				status_message("Fast Forward");
				cc = 'f';
			}
			break;

		case SLOW:
			act = int (gtk_toggle_button_get_active
				   ((GtkToggleButton *) widget));
			if (act && threadp){
				status_message("Slow Motion");
				cc = 'm';
			}
			break;

		case FSKP:
			if (act){
				status_message("Forward Skip");
				cc = 259;
			}
			break;


		case BSKP:
			if (act){
				status_message("Backward Skip");
				cc = 258;
			}
			break;

		default:
			break;

		}
		if (cc){
			uint64_t dummy;
			av_switches(cc, &pdinfo.sw, &dummy);
		}
	}
}



void sfile_ok_sel(GtkWidget * w, GtkFileSelection * fs)
{
        gchar *name;
	char buf[80];
	ostringstream str(string(buf, 80));

        name = gtk_file_selection_get_filename(fs);
        if (name) {
                int len = strlen(name);
                strncpy(savefile, name, len);
                savefile[len] = '\0';
                gtk_widget_destroy(GTK_WIDGET(fs));
                sfileset = TRUE;

		str << "Save file: " << savefile << ends;
		status_message(buf);

        }
}

void pfile_ok_sel(GtkWidget * w, GtkFileSelection * fs)
{
        gchar *name;
	char buf[80];
	ostringstream str(string(buf, 80));

        name = gtk_file_selection_get_filename(fs);
        if (name) {
                int len = strlen(name);
                strncpy(playfile, name, len);
                playfile[len] = '\0';
                gtk_widget_destroy(GTK_WIDGET(fs));
                pfileset = TRUE;

		str << "Play file: " << playfile << ends;
		status_message(buf);

        }
}


void load(GtkWidget * w, GtkFileSelection * fs)
{
        GtkWidget *filew;

        pfileset = FALSE;

        filew = gtk_file_selection_new("File selection");

        gtk_signal_connect(GTK_OBJECT
                           (GTK_FILE_SELECTION(filew)->ok_button),
                           "clicked", (GtkSignalFunc) pfile_ok_sel, filew);

        gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION
                                             (filew)->cancel_button),
                                  "clicked",
                                  (GtkSignalFunc) gtk_widget_destroy,
                                  GTK_OBJECT(filew));

        gtk_widget_show(filew);
}

void save(GtkWidget * w, GtkFileSelection * fs)
{
        GtkWidget *filew;

        sfileset = FALSE;

        filew = gtk_file_selection_new("File selection");

        gtk_signal_connect(GTK_OBJECT
                           (GTK_FILE_SELECTION(filew)->ok_button),
                           "clicked", (GtkSignalFunc) sfile_ok_sel, filew);

        gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION
                                             (filew)->cancel_button),
                                  "clicked",
                                  (GtkSignalFunc) gtk_widget_destroy,
                                  GTK_OBJECT(filew));

        gtk_widget_show(filew);
}

void create_tpwindow ()
{
	GtkWidget *tpwindow, *vbox1, *menubar1, *file1;
	//GtkWidget *device1;
	GtkWidget *menuitem;
	GtkWidget *handlebox, *tool;
	GtkWidget *time;
	//GtkWidget *status;
	GtkWidget *widget;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	rdinfo.stop = 1;
	pdinfo.stop = 1;
	tpwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (tpwindow), "tpwindow", tpwindow);
	gtk_window_set_title (GTK_WINDOW (tpwindow), "TuxPlayer");
	gtk_window_set_default_size (GTK_WINDOW (tpwindow), 100, 50);
	//	gtk_window_set_policy (GTK_WINDOW (tpwindow), FALSE, FALSE, FALSE);
	gtk_widget_show (tpwindow);
	
	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (tpwindow), vbox1);
	gtk_widget_show (vbox1);
	
	
	menubar1 = gtk_menu_bar_new ();
	gtk_widget_show (menubar1);
	gtk_box_pack_start (GTK_BOX (vbox1), menubar1, TRUE, TRUE, 0);
	
	file1 = CreateBarSubMenu(menubar1, _("File"));
	menuitem = CreateMenuItem(file1, _("Quit"), "^q", _("Quit"),
			       GTK_SIGNAL_FUNC(quit), (void *) "quit",
			       accel_group);
	

	file1 = CreateBarSubMenu(menubar1,"Options");

	menuitem = CreateMenuItem(file1, "Set Play File", "^l",
				  "Set Play File",
				  GTK_SIGNAL_FUNC(load), NULL, accel_group);

	menuitem = CreateMenuItem(file1, "Set Record File", "^s",
				  "Set Record File",
				  GTK_SIGNAL_FUNC(save), NULL, accel_group);



	
	handlebox = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(vbox1), handlebox, FALSE, FALSE, 0);

	
	GtkWidget *pixi;


	GtkWidget *toolbar;
	toolbar =
	    gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
	gtk_container_add(GTK_CONTAINER(handlebox), toolbar);
	gtk_widget_show(toolbar);
	
	tool = NULL;

	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_fskp);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_BUTTON,
					   NULL,
					   "FSkp", "FSkp", "FSkp", 
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(FSKP));
	
	
	
	tool = NULL;
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_ffwd);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "FFwd", "FFwd", "FFwd", 
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(FFWD));

	
	
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_stop);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "Stop", "Stop", "Stop", 
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(STOP));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tool), TRUE);
	stwidget = tool;
	
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_pause);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "Pause", "Pause", "Pause", 
					   pixi,
					   (GtkSignalFunc) switches,
					   gpointer(PAUSE));
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_play);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "Play", "Play", "Play", 
					   pixi,
					   (GtkSignalFunc) switches,
					   gpointer(PLAY));
	
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_record);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "Record", "Record", 
					   "Record",
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(RECORD));
	  
	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_slow);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_RADIOBUTTON,
					   tool,
					   "Slow", "Slow", "Slow", 
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(SLOW));



	pixi = CreateWidgetFromXpm(handlebox, (gchar **) xpm_bskp);
	tool = gtk_toolbar_prepend_element(GTK_TOOLBAR(toolbar),
					   GTK_TOOLBAR_CHILD_BUTTON,
					   NULL,
					   "BSkp", "BSkp", "BSkp", 
					   pixi, 
					   (GtkSignalFunc) switches,
					   gpointer(FSKP));



	
	gtk_widget_show(handlebox);

	time = gtk_progress_bar_new ();
	
	gtk_widget_show (time);
	gtk_box_pack_start (GTK_BOX (vbox1), time, FALSE, FALSE, 0);
	gtk_progress_set_activity_mode (GTK_PROGRESS (time), TRUE);
	gtk_progress_set_show_text (GTK_PROGRESS (time), TRUE);
	
//create statusbar
        widget = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widget)
                                       , GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);
        gtk_container_set_border_width(GTK_CONTAINER(widget), 0);
        gtk_box_pack_start(GTK_BOX(vbox1), widget, FALSE, FALSE, FALSE);
        statusbar = gtk_statusbar_new();
        gtk_object_set_data(GTK_OBJECT(tpwindow), "statusbar", statusbar);
        gtk_widget_show(statusbar);
        gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(widget),
                                              statusbar);
        contextid =
            gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbar),
                                         "Statusbar");
        gtk_statusbar_push(GTK_STATUSBAR(statusbar), contextid,
                           _("Welcome to TuxPlayer"));
        gtk_widget_show(widget);

}





int main(int argc, char *argv[])
{
	int c;
	//int bpp = 0, remote = 0, norm = 0, onoff = 1, channel = 0;
	int ipaq = 0;
	
	gtk_set_locale();
#ifdef ENABLE_NLS	
	bindtextdomain(PACKAGE, LOCALE_DIR);
	textdomain(PACKAGE);
#endif



	for (;;) {
		if (-1 == (c = getopt(argc, argv, "ihd:")))
			break;
		switch (c) {
		case 'i':
			ipaq = 1;
			break;
		case 'd':
			device = atoi(optarg);
			break;
		case 'h':
		default:
			cerr << _("usage: ") << argv[0] << _("  [ options ] ") 
			     <<	endl << endl << _("options:") << endl 
			     << _("    -i        use ipaq dimensions") << endl 
			     << _("    -d <n>    video device nb   ") 
			     << endl;
			exit(1);
		}
	}

	if (ipaq) {
		XDIM = 310;
		YDIM = 230;
	}

	gtk_init(&argc, &argv);
	
	accel_group = gtk_accel_group_new ();
	create_tpwindow ();
	gtk_main();

	return 0;
}

