/* 
    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _COMMON_HH_
#define _COMMON_HH_

#include <gtk/gtk.h>
#include <DVB.hh>

#define STRSIZE 80

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
/*
 * Standard gettext macros.
 */

#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  ifndef gettext
#    define gettext(String) (String)
#  endif
#  ifndef dgettext
#    define dgettext(Domain,Message) (Message)
#  endif
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


GtkWidget *CreateMenuItem(GtkWidget * menu, char *szName, char *szAccel,
                          char *szTip, GtkSignalFunc func, gpointer data, 
			  GtkAccelGroup *accel_group);
GtkWidget *CreateBarSubMenu(GtkWidget * menu, char *szName);
void status_message(char *buf);
GtkWidget *CreateWidgetFromXpm(GtkWidget * window, gchar ** xpm_data);
#endif /*_COMMON_HH_ */
