#ifndef _DVB_DEV_HH_
#define _DVB_DEV_HH_

extern "C" {
#include <stdint.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/poll.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <sys/time.h>
#include <time.h>

#include <linux/dvb/dmx.h>
#include <linux/dvb/frontend.h>
#include <linux/dvb/video.h>

#include <channel.h>
}

#include <sstream>
#include <iostream>
#include <iomanip>
using namespace std;

#include <osd.hh>
#include <devices.hh>

#ifndef MAXNAM
#define MAXNAM 80
#endif



#define FRONT_DVBS 1
#define FRONT_DVBC 2
#define FRONT_DVBT 3


#define DEC(N) dec << setw(N) << setfill('0') 
#define HEX(N) hex << setw(N) << setfill('0') 

#define MAXSECSIZE 4096

#define NK 10
enum {LNB=0,DIS,ROTOR,TRANS,CHAN,BOU,SAT,PICS,SWI,NTW};
static const int nums[]={LNB,DIS,ROTOR,TRANS,CHAN,BOU,SAT,PICS,SWI,NTW};
static const int maxs[]={  32,  32,    32,  512,16384,512,100, 50, 10, 100};

enum{DVB_ORIG=0, DVB_NOKIA, DVB_XML};

#define ADAPTER           "/dev/dvb/adapter"
#define FRONT_DEV         "/frontend0"
#define DEMUX_DEV         "/demux0"


class DVB {
public:

	int fd_frontend;
	int fd_demuxa;
	int fd_demuxv;
	int fd_demuxpcr;
	int fd_demuxtt;
        int fdvb;

	int minor;
	int max_tpid;
	int max_satid;
	int max_chanid;
	
	struct dvb_diseqc_master_cmd dcmd;
	fe_sec_tone_mode_t tone;
	fe_sec_voltage_t voltage;
        int burst;
 	struct dmx_pes_filter_params pesFilterParamsV; 
	struct dmx_pes_filter_params pesFilterParamsA; 
	struct dmx_pes_filter_params pesFilterParamsPCR; 
	struct dmx_pes_filter_params pesFilterParamsTT; 
	struct dvb_frontend_parameters front_param;
        int front_type;
	int dvr_enabled;
        OSD osd;

	fe_status_t status;
	uint32_t ber, uncorrected_blocks;
	uint16_t snr, signal;


        struct Lnb *lnbs;
        struct DiSEqC *diseqcs;
        struct Rotor *rotors;
        struct Transponder *tps;
        struct Channel *chans;
        struct Bouquet *bouqs;
        struct Sat *sats;
        struct Picture *pics;
        struct Switch *swis;
        struct Network *ntws;
        int num[NK];
	int oldsec;
	int tryit;
	int oldpol;

	DVB(){
		max_tpid = 0;
		max_satid = 0;
		max_chanid = 0;
		minor = 0;

		fd_frontend = -1;
		fd_demuxa = -1;
		fd_demuxpcr = -1;
		fd_demuxv = -1;
		fd_demuxtt = -1;
		fdvb = -1;
	}

	DVB(int i){
		max_tpid = 0;
		max_satid = 0;
		max_chanid = 0;
	
		fd_frontend = -1;
		fd_demuxa = -1;
		fd_demuxpcr = -1;
		fd_demuxv = -1;
		fd_demuxtt = -1;
		fdvb = -1;
	        init("","",i);
	}

        DVB(char *a, char *b) {
		max_tpid = 0;
		max_satid = 0;
		max_chanid = 0;
	
		fd_frontend = -1;
		fd_demuxa = -1;
		fd_demuxpcr = -1;
		fd_demuxv = -1;
		fd_demuxtt = -1;

		fdvb = -1;
	        init(a,b,0);
	}

	~DVB();
  
	void use_osd(int fd = -1){
		char dvn[32];
		ostringstream str1(string(dvn,32));
		if (fd < 0) fd = 0;
		str1 << "/dev/dvb/adapter" << fd << "/osd0" << ends;
		fdvb = open(dvn, O_RDWR);
		
		if (fdvb >= 0){
			cerr << dvn <<  " for OSD" << endl;
			osd.init(fdvb);
		} else perror("osd");
		osd.Open(80, 500, 640, 540, 2, 0, 2);
		osd.SetColor(0, 0, 0, 0, 255);
		osd.SetColor(1, 240, 240, 240, 255);
		osd.Show();
	}

	void close_osd(){
		osd.Close(fdvb);
		close(fdvb);
	}
  
	int DVR_enabled(){
		return dvr_enabled;
	}

	void enable_DVR(){
		dvr_enabled = 1;
	}

	void disable_DVR(){
		dvr_enabled = 0;
	}

        void init(char *a="/dev/video0", char *b="/dev/vbi0",int minor = 0);

	inline void init(char *a, char *b){
		init(a,b,0);
	}

	int check_frontend();

	void set_apid(ushort apid);
	void set_vpid(ushort vpid); 
	void set_pcrpid(ushort vpid); 
	void set_ttpid(ushort ttpid); 
	int set_lnb(int dis); 
	void set_diseqc_nb(int nr); 
	void set_front(void); 
	void get_front(void); 

	void scan_pf_eit(int chnr,
			 void (*callback)(uint8_t *data, int l, int pnr, 
					  int c_n));

	void scan_pf_eit(Channel *chan, 
			 void (*callback)(uint8_t *data, int l, int pnr, 
					  int c_n));
	void scan_pf_eit(int chnr);


	int search_in_TP(Transponder &tp);
	int search_in_TP(uint16_t tpid, uint16_t satid);
	int GetSection(uint8_t *buf, 
		       uint16_t PID, uint8_t TID, uint16_t TIDExt, 
		       uint16_t FilterTIDExt, 
		       uint8_t secnum, uint8_t &msecnum);
	int GetSection(uint8_t *buf, 
		       uint16_t PID, uint8_t *filter, uint8_t *mask,
		       uint8_t secnum, uint8_t &msecnum); 
	int GetSection(unsigned char *buf, ushort PID, unsigned char sec,
		       unsigned char secnum, unsigned char &msecnum); 
	int SetFilter(uint16_t pid, unsigned char *filter, 
		      unsigned char *mask,
		      uint32_t timeout, uint32_t flags); 
	uint16_t SetFilter(uint16_t pid, uint16_t section, uint16_t mode); 
	int CloseFilter(int h);
	

	void bar2(int x, int y, int w, int h, int val, int col1, int col2);

        int SetTP(unsigned int, unsigned int);
        int scan(void);
        int scan_all_tps(void);
        int scan_lnb(struct Lnb &);
        int scan_cable(Sat &sat);
        int scan_sat(struct Sat &);
        int scan_tp(struct Transponder &);

        int AddLNB(int id, int t, uint l1, uint l2, uint sl,
		   int dnr, int dis, int sw);
	int AddSat(Sat &sat);
        int AddSat(int satid, unsigned int lnbid, char *name, uint fmin, uint fmax);
        int AddTP(Transponder &tp);
        int AddChannel(Channel &chan);
	int check_pids(Channel *chan);
	void check_all_pids();
	void parse_sdt(uint8_t *buf, int count, Channel *chan);
	void scan_sdt(Channel *chan);

        int channel_num(void) {
	        return num[CHAN];
	};
	  
        int channel_change(int n) {
	        return 0;
	};
        int SetChannel(uint16_t, uint16_t, uint16_t, uint16_t);
	int SetChannel(Channel *chan,  char* apref=NULL, uint16_t *apidp=NULL, 
		       uint16_t *vpidp=NULL) ;
        int SetChannel(int chnr, char *apref=NULL, uint16_t *apidp=NULL, 
		       uint16_t *vpidp=NULL);
        int GetChannel(int chnr, struct channel *);
        int NumChannel(void) {
	        return num[CHAN];
	}
	int tune_it(struct dvb_frontend_parameters *qpsk);
	void find_satid(Channel &chan);
	int check_input_format(istream &ins);
	void read_original(istream &ins);
	int get_all_progs(uint16_t *progbuf, uint16_t *pnrbuf, int length);
	uint16_t find_pnr(uint16_t vpid, uint16_t apid);
	int get_pids(uint16_t prog_pid, uint16_t *vpid, uint16_t *apids);

        friend ostream &operator<<(ostream &stream, DVB &x);
        friend istream &operator>>(istream &stream, DVB &x);

};

#define NOKIA_MAX_SAT 4
class nokiaconv{
public:
	DVB *dvb;
	struct lnb_sat_l{
		int n;
		int diseqc[NOKIA_MAX_SAT];
		char sat_names[NOKIA_MAX_SAT][MAXNAM+1];
		int satid[NOKIA_MAX_SAT];
	} lnb_sat;

	nokiaconv(DVB *d){
		dvb = d;
	}

        friend istream &operator>>(istream &stream, nokiaconv &x);
};

#define XML_MAX_SAT 4
class xmlconv{
public:
	DVB *dvb;
	struct lnb_sat_l{
		int n;
		int diseqc[XML_MAX_SAT];
		char sat_names[XML_MAX_SAT][MAXNAM+1];
		int satid[XML_MAX_SAT];
	} lnb_sat;

	xmlconv(DVB *d){
		dvb = d;
	}
	int read_stream(istream &ins, int nchan);
	int read_desc(istream &ins, int nchan);
	int read_serv(istream &ins, int ctp, int csat);
	int read_trans(istream &ins, int satid);
	int read_sat(istream &ins, int satid = -1);
	int skip_tag(istream &ins, char *tag);
	int read_iso639(istream &ins, int nchan, int apids);

        friend istream &operator>>(istream &stream, xmlconv &x);
};

void hdump(unsigned char *buf, int n);
int get_dvbrc(char *path, DVB &dv, int dev, int len);
int set_dvbrc(char *path, DVB &dv, int dev, int len);

#endif
