/* 
    ntuxzap

    Copyright (C) 2000 Marcus Metzler (mocm@convergence.de)
    for convergence integrated media

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sstream>
#include "ntuxzap.hh"
#include "channel.hh"

#ifdef HAVE_XCURSES
char *XCursesProgramName="alphalist_ex";
#endif

/*
 * This program demonstrates the Cdk alphalist widget.
 */
#define	MAXINFOLINES	10000

DVB dvb;
ChannelList chlist[NLIST];
CDKSCREEN *cdkscreen		= (CDKSCREEN *)NULL;
int cchan = -1;
int it = 0;
int oit = 1;
int dev = 0;

static void get_dvbfav(char *path, int nb, int len)
{
        const char *home = getenv("HOME");
        const char *file = ".dvbfav";

	ostringstream str(string(path,len));
	
	str << home << "/" << file << nb ;
	if (dev)
		str << "." << dev;
	str << ends; 
}

static void load_ch(int nb)
{
	char filen[80];

	get_dvbfav(filen,nb,80);
	cout << _("Reading channel list from ") << filen << endl;
	chlist[nb].init(filen);
}

void set_format(video_format_t format)
{
        int ans;
	int fd;

        char path[256];
	ostringstream str(string(path,256));
	
	str << "/dev/ost/video" << dev ;
	str << ends;

	if ((fd = open(path, O_RDWR)) < 0){
	    perror("display");
	    return;
	}

        if ( (ans = ioctl(fd,VIDEO_SET_FORMAT, format) < 0)){
                perror("VIDEO SET FORMAT: ");
        }
	close(fd);
}

static int cnum (gChannel & ch)
{
	char buf[80];
        ostringstream str(string(buf, 80));
	uint64_t dvb_num = 0;

        uint16_t onid  =  uint16_t((ch.DVB_Num() & 
				    0xFFFF000000000000ULL) >> 48);
	uint16_t satid =  uint16_t((ch.DVB_Num() & 
				    0x0000FFFF00000000ULL) >> 32);
        uint16_t tpid  =  uint16_t((ch.DVB_Num() & 
				    0x00000000FFFF0000ULL) >> 16);
	ushort sid     =  ushort   (ch.DVB_Num() & 0x000000000000FFFFULL);


	int chnr;
	int found=0;
	for (chnr=0; chnr< dvb.num[CHAN]; chnr++) {
		if (dvb.chans[chnr].pnr==sid   && 
		    (dvb.chans[chnr].onid==onid || onid == 0xffff) && 
		    (dvb.chans[chnr].satid==satid || satid == 0xffff)  && 
                    (dvb.chans[chnr].tpid==tpid)) {
		  found = 1;
		  break;
                }
	}
	if (!found){
		for (chnr=0; chnr< dvb.num[CHAN]; chnr++) {
			if (dvb.chans[chnr].pnr==sid){
				found = 1;
				break;
			}
		}
	}

	if (!found) chnr = -1;
	dvb_num |= ((uint64_t)dvb.chans[chnr].onid  << 48) & 
		0xFFFF000000000000ULL;
	dvb_num |= ((uint64_t)dvb.chans[chnr].satid << 32) & 
		0x0000FFFF00000000ULL;
	dvb_num |= ((uint64_t)dvb.chans[chnr].tpid  << 16) & 
		0x00000000FFFF0000ULL;
	dvb_num |=           (uint64_t)dvb.chans[chnr].pnr & 
		0x000000000000FFFFULL;
	ch.DVB_Num()= dvb_num;
	return chnr;
}

int save_ch(EObjectType cdktype, void *object, void *data, chtype key)
{
	int nb = int(data);
	char filen[80];
	char buf[80], *mesg[10], temp[256];

	ostringstream str(string(buf, 80));

	get_dvbfav(filen,nb,80);
	
	mesg[0] = _("<C>Saving Channel List");
	sprintf (temp, _("<C>Favorite %d"), nb);
	mesg[1] = copyChar (temp);
	mesg[2] = "";
	mesg[3] = _("<C>Press any key to continue.");
	popupLabel (cdkscreen, mesg, 4);

	ofstream fout(filen);
	fout << _("# This is the list of favorite channels") << endl;
	fout << _("# The format is:") << endl;
	fout << _("#   *   = start of a channel declaration") << endl;
	fout << _("#  Channel    : <Name>") << endl;
	fout << _("#               <dvbnum> id of channel in DVB structure")
	    << endl;
	fout << chlist[nb] << endl;
	return 0;
}

int del_ch(EObjectType cdktype, void *object, void *data, chtype key)
{
	int nb = int(data);
	char *mesg[10], temp[256];


	sprintf (temp, _("<C>Deleting Channel %s from List")
		 ,dvb.chans[cchan].name) ;
	mesg[0] = copyChar(temp);
	sprintf (temp, _("<C>Favorite %d"), nb);
	mesg[1] = copyChar (temp);
	mesg[2] = _("(the change will occur after next selection)");
	mesg[3] = _("<C>Press any key to continue.");
	popupLabel (cdkscreen, mesg, 4);
	
	chlist[nb].DelChannel(dvb.chans[cchan].name);
	it = nb+1;
	oit = 0;

	return 0;
}

int set_audio(EObjectType cdktype, void *object, void *data, chtype key)
{
  
	int anum = dvb.chans[cchan].apidnum;
	if (anum < 2) return 0;

	char *in[anum];

	for (int i = 0; i < anum; i++) {
		stringstream str;
		str << _("Audio ") << i << ends;
		in[i] = copyChar((char*)(str.str().c_str()));
	}
	stringstream str;
	str << _("<C></B/24>Choose Audio \n<C>") << ends;
	char *t = copyChar((char*)(str.str().c_str()));
	char *l  = _("</B>AUDIO: ");
	
	CDKITEMLIST *ilist;

	ilist = newCDKItemlist(cdkscreen,LEFT,LEFT,
			       t,l,in,anum,0,TRUE,TRUE);
	int audion = activateCDKItemlist (ilist, NULL);
	if(ilist->exitType == vNORMAL){
		dvb.set_apid(dvb.chans[cchan].apids[audion]);  
	}
	destroyCDKItemlist(ilist);
	refreshCDKScreen(cdkscreen);
	return 0;
}


int add_ch(EObjectType cdktype, void *object, void *data, chtype key)
{
	char *in[NLIST];
	int chnr = cchan;

	if (cchan < 0) return -1;

	for (int i=0; i<NLIST; i++){
		stringstream str;
		str << _("Favorite ") << i << ends;
		in[i] = copyChar((char*)(str.str().c_str()));
	}
	stringstream str;
	str << _("<C></B/24>Add channel ") << dvb.chans[cchan].name 
	    << _(" to list\n<C>") << ends;
	char *t = copyChar((char*)(str.str().c_str()));
	char *l  = _("</B>List: ");
	
	CDKITEMLIST *ilist;

	ilist = newCDKItemlist(cdkscreen,LEFT,LEFT,
			       t,l,in,NLIST,0,TRUE,TRUE);
	int clistn = activateCDKItemlist (ilist, NULL);
	if(ilist->exitType == vNORMAL){
	        int k = 0, i = 0, j = 0;
		
		while (dvb.tps[k].id != dvb.chans[chnr].tpid)
			k++;
		while (dvb.tps[k].satid != dvb.sats[i].id)
			i++;
		while (dvb.sats[i].lnbid != dvb.lnbs[j].id)
			j++;
		cerr << chnr << endl;

		gChannel ch(dvb.chans[chnr], dvb.tps[k], dvb.lnbs[j]);
		chlist[clistn].AddChannel(ch);
		
	}
	destroyCDKItemlist(ilist);
	refreshCDKScreen(cdkscreen);
	return 0;
}

int getList (CDKALPHALIST *alphaList, int k)
{
	int num = 0;
	char **info = NULL;
	int set = 0;
	int j;
	switch (k){
	case 0:
		num = dvb.num[CHAN];
		info = new (char *) [num];
		for (int i=0; i < num; i++){
			stringstream str;
			str << dvb.chans[i].name << "  (" << i << ")"<< ends;
			info[i] = copyChar((char*)(str.str().c_str()));
		}
		set = 1;
		break;
	case 1 ... NLIST:
		num = chlist[k-1].NumChan();
		info = new (char *) [num];
		j = 0;
		for (int i = 0; i < num; i++) {
			stringstream str;
			int cn = cnum(chlist[k-1](i));
			if (cn >= 0){
				str << chlist[k-1](i).Name() << " (" << cn 
				    << ")" << ends;
				info[j] = copyChar((char*)(str.str().c_str()));
				j++;
			}
		}
		num = j;
		break;
	}
	if (alphaList && info) setCDKAlphalistContents(alphaList, info, num);
	if (k == 0){
		bindCDKObject(vALPHALIST,alphaList, KEY_F1, add_ch, NULL);
	} else {
		bindCDKObject(vALPHALIST,alphaList, KEY_F1, save_ch, 
			      (void *) (k-1));
		bindCDKObject(vALPHALIST,alphaList, KEY_F8, del_ch, 
			      (void *) (k-1));
	}
	bindCDKObject(vALPHALIST,alphaList, KEY_F2, set_audio, NULL);

	delete(info);
	return 0;
}

#define FILELEN 256
int main (int argc, char **argv)
{
   /* Declare variables. */
	char filen[FILELEN];
	WINDOW *cursesWin		= (WINDOW *)NULL;
	char *word			= (char *)NULL;
	CDKALPHALIST *alphaList	= (CDKALPHALIST *)NULL;
	char *title			= "<C></B/24>nTuxZap\n<C>";
	char *label			= _("</B>Channel: ");
	int c,channel = -1;
	int o=0;
	int enable_dvr=0;
	boolean wide=false;

#ifdef ENABLE_NLS
	setlocale(LC_ALL,"");
	bindtextdomain("ntuxzap", LOCALE_DIR);
	textdomain("ntuxzap");
#endif
	filen[0] = '\0';

	for (;;) {
		if (-1 == (c = getopt(argc, argv, "ed:c:of:w")))
			break;
		switch (c) {
		case 'c':
			channel = atoi(optarg);
			break;
			
		case 'w':
			wide=true;
                        break;

		case 'd':
			dev = atoi(optarg);
			break;

		case 'o':
			o = 1;
			break;

		case 'e':
			enable_dvr = 1;
			break;

		case 'f':
			strcpy(filen,optarg);
			break;

		case 'h':
		default:
			cerr << _("usage: ") << argv[0] << _("  [ options ] ") 
			     <<	endl << endl << _("options:") << endl
			     << endl << _("    -c <n>    set channel") << endl
			     << endl << _("    -d <n>    set devices (0 =/dev/ost/xxx0)") << endl
			     << endl << _("    -o        use OSD") << endl
			     << endl << _("    -o        use wide screen") << endl
			     << endl << _("    -f <f>    use <f> as dvbrc") << endl
			     << endl << _("    -e        enable dvr") << endl;
		    
			exit(1);
		}
	}
	
	dvb.init("","",dev);
	if (o) dvb.use_osd(dev);
	if (enable_dvr) dvb.enable_DVR();
	else dvb.disable_DVR();

	if (wide)
		set_format(VIDEO_FORMAT_16_9);
	else
		set_format(VIDEO_FORMAT_4_3);

	if (get_dvbrc(filen,dvb,dev,FILELEN)) {
		cout << _("Found DVB input file ") << filen << endl;
	} else {
		cout << _("Could not find DVB input file ") 
		     << filen << endl;
	}

 	if (channel > -1) {
 		dvb.SetChannel(channel);
  	}


	for (int i = 0; i < NLIST; i++){
		char buf[80];
		ostringstream str1(string(buf, 80));
		
		str1 << _("Favorite ") << i << ends;
		load_ch(i);
	}

	/* Set up CDK. */ 
	cursesWin = initscr();
	cdkscreen = initCDKScreen (cursesWin);

	/* Start color. */
	initCDKColor();
	char *info[1];
	info[0] = copyChar(_("none"));
	alphaList = newCDKAlphalist (cdkscreen, CENTER, CENTER, 
				     0, 0, title, label,
				     info, 1,
				     '.', A_REVERSE, TRUE, FALSE);
	

	while (1){
		if (oit != it) {
			oit = it;
			getList (alphaList,it);
		}

		refreshCDKScreen(cdkscreen);
		word = activateCDKAlphalist (alphaList, NULL);

	/* Determine what the user did. */
		if (alphaList->exitType == vESCAPE_HIT)
		{
			char *in[NLIST+1];
			in[0] = copyChar(_("DVBList"));
			for (int i=0; i<NLIST; i++){
				stringstream str;
				str << _("Favorite ") << i << ends;
				in[i+1] = copyChar((char*)(str.str().c_str()));
			}
			char *t = _("<C></B/24>Choose List\n<C>");
			char *l  = _("</B>List: ");
		 
			CDKITEMLIST *ilist;

			ilist = newCDKItemlist(cdkscreen,LEFT,LEFT,
					       t,l,in,NLIST+1,0,TRUE,TRUE);
			int nit = activateCDKItemlist (ilist, NULL);
			if(ilist->exitType == vNORMAL){
				it = nit;
			}
			destroyCDKItemlist(ilist);
		}
		else if (alphaList->exitType == vNORMAL)
		{
			int i=-1;
			int l = strlen(word);
			l--;
			while (word[l] != '(' && l>0) l--;
			istringstream str(word+l+1);
			str >> i;
			cchan = i;
			if (cchan>= 0) dvb.SetChannel(cchan);
		}
	}
	/* Clean up. */
	destroyCDKAlphalist (alphaList);
	delwin (cursesWin);
	endCDK();
	exit (0);
}

